//
// (C) Copyright 1993-1998 by Autodesk, Inc.
//
// The information contained herein is confidential, proprietary  to
// Autodesk,  Inc., and considered a trade secret as defined in sec-
// tion 499C of the penal code of the State of California.   Use  of
// this information by anyone other than authorized employees of Au-
// todesk, Inc. is  granted  only  under  a  written  non-disclosure
// agreement,  expressly  prescribing  the  scope and manner of such
// use.
//
// DESCRIPTION:
//
// Dockable pane class declaration
//

#ifndef CDOCKPANE_H_
#define CDOCKPANE_H_

// PURPOSE:
// This class implements a dockable pane, MSVC-like. It is based
// on some sample code so the code still has the "sample" look.
//
#include "adui.h" // for CAdUiDockControlBar
#include "subclass.h" // for CSubclassWnd
#include "input.h"
#include "ToolBarEx.h"

class CSampleListView;
class AcMapODTable;


class CDockPaneWindowHook : public CSubclassWnd
{
	friend class IPM;
public:
	DECLARE_DYNAMIC(CDockPaneWindowHook)
    CDockPaneWindowHook(){}
    ~CDockPaneWindowHook(){}
protected:
    // window proc to hook frame using CSubclassWnd implementation
	virtual LRESULT WindowProc(UINT msg, WPARAM wp, LPARAM lp);
};

class CDockPane : public CAdUiDockControlBar
{
	DECLARE_DYNAMIC(CDockPane)

public:
    CDockPane();
	virtual ~CDockPane();

// Operations
public:
    BOOL Create(CWnd* pParentWnd);
    BOOL IsWindowVisible() const;
    void ToggleBarState(BOOL bShrinkIfDocked = TRUE);
	void SetFloatingSize(const CSize& size);

	Adesk::Boolean OnLoadDwg();
	Adesk::Boolean OnUnloadDwg();
	void OnSaveComplete(AcDbDatabase *pDwg, const char *pActualName);

	void PostReactorMessage(WPARAM wParam, LPARAM lParam);

	void GetObjectData(AcDbObjectId pObjId); //IPM passes us the object
	void GetTableFieldNames(AcMapODTable *pODTable);
	void ClearList();

	BOOL UseToolTips();
	BOOL GetToolTipString(CString &str);
	BOOL IsTableSelected(const CString str);

	void StartWatch();
	void EndWatch();

// Overrides

protected:
    //functions for keeping the focus
    void HookMiniFrame();
	void OnBarStyleChange(DWORD oldStyle, DWORD newStyle);

	//{{AFX_MSG(CDockPane)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSelEndOk_OnOff();
	afx_msg void OnSelEndOk_ODT();
	//}}AFX_MSG
	afx_msg LONG OnChangedDockedState(UINT, LONG);
	afx_msg void OnSelChange_OnOff();
	afx_msg void OnSelChange_ODT();
	DECLARE_MESSAGE_MAP()

// Attributes
protected:

	virtual void SizeChanged(CRect *lpRect, BOOL bFloating, int flags);
	
	CDockPaneWindowHook m_MiniFrameHook;
	CToolBarEx m_wndToolBar;
	IPM m_ipm; //input point monitor
	CSampleListView *m_pListView;

	BOOL m_bViewOD;
	BOOL m_bUseToolTips;
	BOOL m_bFloating; //TRUE if we are not docked.
	int m_cbOnOffIndex;
	int m_cbODTableIndex;
	CString m_strToolTip;

};

/////////////////////////////////////////////////////////////////////////////

#endif // CDOCKPANE_H_
